<?php

class WonderSignature
{

    static public function generateRandomString($length)
    {
        $alphabet = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $alphabetLength = strlen($alphabet);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomIndex = mt_rand(0, $alphabetLength - 1);
            $randomString .= $alphabet[$randomIndex];
        }
        return $randomString;
    }

    public function parseCredential($credential)
    {
        $parts = explode('/', $credential);
        if (count($parts) !== 3) {
            throw new InvalidArgumentException('Invalid credential format');
        }

        return array(
            'appid' => $parts[0],
            'request_time' => $parts[1],
            'algorithm' => $parts[2]
        );
    }

    public function generateSignatureMessage($credential, $nonce, $method, $uri, $body = null)
    {
        $parsedCredential = $this->parseCredential($credential);

        $signatureKey = hash_hmac('sha256', $parsedCredential['request_time'],$nonce,true);

        $signatureKey = hash_hmac('sha256',  $parsedCredential['algorithm'],$signatureKey, true);

        $content = strtoupper($method) . "\n" . $uri;
        if ($body !== null && strlen(trim($body)) > 0) {
            $content .= "\n" . $body;
        }
        return bin2hex(hash_hmac('sha256', $content, $signatureKey,true));
    }
    public function signature($privateKey, $credential, $nonce, $method, $uri, $body = null)
    {
        $plainSignature = $this->generateSignatureMessage($credential, $nonce, $method, $uri, $body);

        $privateKeyResource = openssl_pkey_get_private($privateKey);
        if (!$privateKeyResource) {
            throw new Exception('can not load private key：' . $this->getOpensslError());
        }

        $signature = '';
        $signSuccess = openssl_sign($plainSignature, $signature, $privateKeyResource, OPENSSL_ALGO_SHA256);
        openssl_free_key($privateKeyResource);

        if (!$signSuccess) {
            throw new Exception('can not signature：' . $this->getOpensslError());
        }

        return base64_encode($signature);
    }

    public function verifySignature($publicKey, $receivedSignature, $credential, $nonce, $method, $uri, $body = null)
    {
        $plainSignature = $this->generateSignatureMessage($credential, $nonce, $method, $uri, $body);

        $publicKeyResource = openssl_pkey_get_public($publicKey);
        if (!$publicKeyResource) {
            throw new Exception('can not load public key：' . $this->getOpensslError());
        }

        $receivedSignatureBytes = base64_decode($receivedSignature);
        if ($receivedSignatureBytes === false) {
            throw new Exception('base64 decode fail');
        }

        $verifyResult = openssl_verify($plainSignature, $receivedSignatureBytes, $publicKeyResource, OPENSSL_ALGO_SHA256);
        openssl_free_key($publicKeyResource);

        if ($verifyResult === -1) {
            throw new Exception('signature verify failed：' . $this->getOpensslError());
        }

        return $verifyResult === 1;
    }

    private function getOpensslError()
    {
        $errors = array();
        while ($error = openssl_error_string()) {
            $errors[] = $error;
        }
        return implode('; ', $errors);
    }
}
