import hashlib
import hmac
import secrets
import string
import requests
import base64
import json
import datetime
from cryptography.hazmat.primitives import hashes, serialization
from cryptography.hazmat.primitives.asymmetric import padding
from cryptography.hazmat.backends import default_backend


def generate_random_string(length):
    alphabet = string.ascii_letters + string.digits
    random_string = ''.join(secrets.choice(alphabet) for _ in range(length))
    return random_string


def parse_credential(credential):
    output = credential.split("/")
    return {
        "appid" : output[0],
        "request_time" : output[1],
        "algorithm" : output[2]
    }

def generate_signature_message(credential,nonce,method,uri,body = None):
    parsed_credential = parse_credential(credential)
    hmac_sha256 = hmac.new(bytes(nonce,'utf-8'),bytes( parsed_credential['request_time'],'utf-8'), hashlib.sha256)
    signature_key = hmac_sha256.digest()
    hmac_sha256 = hmac.new(signature_key,bytes( parsed_credential['algorithm'],'utf-8'), hashlib.sha256)
    signature_key = hmac_sha256.digest()
    content = "{}\n{}".format(method,uri)
    if body is not None and len(body) > 0:
        content += "\n"
        content += body
    hmac_sha256 = hmac.new(signature_key,bytes(content,'utf-8'), hashlib.sha256)
    plain_signature = hmac_sha256.hexdigest()
    return  plain_signature


def signature(private_key,credential,nonce,method,uri,body = None) :
    plain_signature = generate_signature_message(credential,nonce,method,uri,body)
    private_key = serialization.load_pem_private_key(
        private_key.encode("utf-8"),
        password=None,
        backend=default_backend()
    )
    sign = private_key.sign(bytes(plain_signature.encode("utf-8")),padding.PKCS1v15(),hashes.SHA256())
    return base64.b64encode(sign)

def verify_signature(webhook_public_key,received_signature,credential,nonce,method,uri,body = None) :
    plain_signature = generate_signature_message(credential,nonce,method,uri,body)
    public_key = serialization.load_pem_public_key(webhook_public_key.encode('utf-8'),backend=default_backend())
    received_signature_bytes = base64.b64decode(received_signature)
    return public_key.verify(
        received_signature_bytes,
        plain_signature.encode("utf-8"),
        padding.PKCS1v15(),
        hashes.SHA256()
    )


def test_signature():
    signature_private_key = '''-----BEGIN RSA PRIVATE KEY-----
MIIEogIBAAKCAQBS1Gv7Z34T1RnbNYS4TbvUOtF+zqbkNhQxHt8YAdlAjVUV9pAV
eZR7WAVVcK5oGD5PAH/U5RwdGNMXYYdaqSmHTa0ZWUcHb/juRtLuEgUegQo/e5GW
7Rs2QmPny0rWTEbqFUV3WUP96bGNpidy7jvR+NHKk/iUynASPMPXib4fKL3atGyD
5/nCPgyEYdwC/c+C9JGL+jBhe2xbDYzld13XbJzPucHCZklM9kfca5Sfj8p2lM8v
4feIdJf4zFDwcjjU9X3PkWOrXos1UNoNzTSe46OvKrlQE0zO4VQ9I0gj/jnLbQ3d
u358q9a073wnZAKi1ZugmkSNR7TvKrPGymGfAgMBAAECggEAD54X4iZIYmrq3idA
KBQYF1Mjzxod46fCtORSQk+O7Bn58hM0Zagv8/XLw6lkaSIxFWpNsBGm9GGK47yy
7cg5mVZvDfmEaAWX1S2rddIV/wNrsD6XW/LHD7sC5WCycqedM2PhXjiJlmWq4b9z
brs2skeNHvo5g6yL5xRoBMrm+y7XK78FYXCGj2yZU+5UkOcRjoyAoRi3puU/lPWg
UvdW1UANr3i7cCO0abzmezhZKUcUqUW34iHLbb4vQFFq84g/izbLUhC9c/BGjUaO
flkihtm3JfU6bvwNyU6lNilHK+uHj93IasKNskZSGYEmQj7MFWlqcyYxql4BETwL
8uupwQKBgQCh/A0OSlZahnjFy0Zo9UKL1koh7cJmSAV6hGfaJDR1mDGY/tuyqpcX
qlaYM+7MhXFHlO7qZ1/XFI2bCYBVM7o7vKbDK4E15jNYebRwWEUYB35gf8sL70e4
fHJC1H5hlIfg4l2mn1d8e33xGdkb2HAKwvYwg2nNFweXmUV7efruPwKBgQCC52nA
yW39H7y5q7XdGWHMf1tAfsMobpbFcAgZIEbJE4+6YkrInc3Qq6ZfiwK62dRN4Um4
c7MXE9h3LOUzYlOHw9ZaKinA6LQ7Ie4VibPD1w3Ll7JfFYp9xkDw8wC7cbgH61+S
fVRbZuuNpSFHO4+Lz28NYOurWKxks14+rnp0oQKBgQCA76Zcx6Mw73TWzFVBWmgb
8viTRTPGQnHJ8fbQVp1DNV/VTpgGAW+/MKE5Ca19MoLW3Z/HCX3qL7v/unJiX4hP
4HxFQi3Zf2FDfay4+CoXVG+t1EsFNvO5z6ULuSTX+2ilAspUxOTYe1vmPBLq7T9R
8ZoRR6lBzKEIdMIv5Qpt9QKBgHfGQAgrBl2N9YO5rmzAdbDEcv0/P1g2X/QFfxNm
af4/zMnQd/a6FQCynkdbjULkXxJnaanBC4O5H95jkNAETsOxl+bmH1AoXAijEhJY
7cfqdO/tPEMuFYrhpLgS0H+yHJ36andB/7amJC91gU6JG93kDguiu+ALAaoeSMR3
pwohAoGAChmnupFN8b9PmIgkm5nrmpSMa489E4mKQHPZakXT9osL3IpcOoCasnds
a8ar/BO+bKLcGr67tZiR222/RI9W90aa1E+4fHRJAgXBoVGXbVOFTjnt0ftK5R6K
U8nGC++qqT6WJB7omNnLsbq8+urZQgmkfqJCPZ0yHr+J3PylUO4=
-----END RSA PRIVATE KEY-----'''

    http_method = "POST"
    domain = "https://gateway-stg.wonder.today"
    request_uri = "/svc/payment/api/v1/openapi/echo"

    body = {"message" : "Hello, Wonder!"}
    request_body =  json.dumps(body)
    current_time_utc = datetime.datetime.utcnow()
    request_time = current_time_utc.strftime("%Y%m%d%H%M%S")
    appid = "a74cb280-b3bd-4892-9a80-05090663d71e"
    credential = "{}/{}/{}".format(appid,request_time,"Wonder-RSA-SHA256")
    nonce = generate_random_string(16)

    hexed_signature = signature(signature_private_key,credential,nonce,http_method,request_uri,request_body)

    message="curl -XPOST -H 'Content-Type: application/json' -H 'Credential: {}' -H 'Nonce: {}' -H 'Signature: {}' {} -d '{}'".format(credential,nonce,hexed_signature.decode('utf-8'),domain + request_uri,request_body)
    print(message)

test_signature()


